/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.api.extension.model;

import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.mule.tooling.client.api.extension.model.ClassValueModel;
import org.mule.tooling.client.api.extension.model.PathModel;
import org.mule.tooling.client.api.feature.Feature;

public class DisplayModel {
    private String displayName;
    private String summary;
    private String example;
    private PathModel pathModel;
    private Feature<Optional<ClassValueModel>> classValueModel;

    private DisplayModel() {
    }

    public DisplayModel(String displayName, String summary, String example, PathModel pathModel, ClassValueModel classValueModel) {
        this.displayName = displayName;
        this.summary = summary;
        this.example = example;
        this.pathModel = pathModel;
        this.classValueModel = Feature.enabled(Optional.ofNullable(classValueModel));
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getSummary() {
        return this.summary;
    }

    public String getExample() {
        return this.example;
    }

    public Optional<PathModel> getPathModel() {
        return Optional.ofNullable(this.pathModel);
    }

    public Feature<Optional<ClassValueModel>> getClassValueModel() {
        if (this.classValueModel == null) {
            this.classValueModel = Feature.disabled();
        }
        return this.classValueModel;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DisplayModel) {
            DisplayModel other = (DisplayModel)obj;
            return Objects.equals(other.getDisplayName(), this.getDisplayName()) && Objects.equals(other.getSummary(), this.getSummary()) && Objects.equals(other.getPathModel(), this.getPathModel()) && Objects.equals(other.getExample(), this.getExample()) && Objects.equals(other.getClassValueModel(), this.getClassValueModel());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.displayName, this.summary, this.example, this.pathModel, this.classValueModel);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

