/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.api.extension.model.parameter;

import java.util.Objects;
import org.mule.tooling.client.api.feature.Feature;

public final class ActingParameterModel {
    private String name;
    private boolean required;
    private Feature<String> extractionExpression;

    private ActingParameterModel() {
    }

    public ActingParameterModel(String name, boolean required) {
        this(name, required, name);
    }

    public ActingParameterModel(String name, boolean required, String extractionExpression) {
        this.name = name;
        this.required = required;
        this.extractionExpression = Feature.enabled(extractionExpression);
    }

    public String getName() {
        return this.name;
    }

    public boolean isRequired() {
        return this.required;
    }

    public Feature<String> getExtractionExpression() {
        if (this.extractionExpression == null) {
            return Feature.disabled();
        }
        return this.extractionExpression;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ActingParameterModel)) {
            return false;
        }
        ActingParameterModel that = (ActingParameterModel)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.required, that.required) && Objects.equals(this.extractionExpression, that.extractionExpression);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.required, this.extractionExpression);
    }

    public String toString() {
        return "ActingParameterModel{name='" + this.name + '\'' + ", required=" + this.required + ", extractionExpression=" + (this.extractionExpression.isEnabled() ? this.extractionExpression.get() : "DISABLED") + '}';
    }
}

