/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.api.value.resolver;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.mule.tooling.client.api.value.resolver.ResolvedValue;
import org.mule.tooling.client.api.value.resolver.ValueResolverFailure;

public class ValueResolverResult {
    private Set<ResolvedValue> values;
    private List<ValueResolverFailure> resolvingFailures;

    public static ValueResolverResult success(Set<ResolvedValue> values) {
        return new ValueResolverResult(values, Collections.emptyList());
    }

    public static ValueResolverResult failure(List<ValueResolverFailure> failures) {
        return new ValueResolverResult(Collections.emptySet(), failures);
    }

    public static ValueResolverResult failure(ValueResolverFailure failure) {
        return ValueResolverResult.failure(Collections.singletonList(failure));
    }

    private ValueResolverResult(Set<ResolvedValue> values, List<ValueResolverFailure> resolvingFailures) {
        this.values = Collections.unmodifiableSet(values);
        this.resolvingFailures = resolvingFailures;
    }

    public Set<ResolvedValue> getResolvedValues() {
        return this.values;
    }

    public List<ValueResolverFailure> getFailures() {
        return this.resolvingFailures;
    }

    public boolean isSuccess() {
        return this.resolvingFailures.isEmpty();
    }
}

