/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.metadata.type;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.tooling.client.api.extension.model.ExtensionModel;
import org.mule.tooling.client.api.extension.model.SubTypesModel;
import org.mule.tooling.client.internal.util.Pair;

public final class TypeRepository {
    private List<SubTypesMappingContainer> mappings = new LinkedList<SubTypesMappingContainer>();
    private Map<String, Map<String, ObjectType>> types = new LinkedHashMap<String, Map<String, ObjectType>>();
    private Map<String, String> extensionTypesInvertedIndex = new LinkedHashMap<String, String>();

    private TypeRepository() {
    }

    public TypeRepository(Set<ExtensionModel> extensions) {
        extensions.stream().map(e -> new TypeCatalogEntry(e.getName(), e.getTypes(), this.toSubTypesMap(e.getSubTypes()))).forEach(e -> {
            this.mappings.add(new SubTypesMappingContainer(e.getSubTypes()));
            e.getTypes().forEach(t -> MetadataTypeUtils.getTypeId((MetadataType)t).ifPresent(id -> {
                if (this.types.containsKey(e.getExtensionName())) {
                    this.types.get(e.getExtensionName()).put((String)id, (ObjectType)t);
                } else {
                    LinkedHashMap<String, ObjectType> extensionTypesMap = new LinkedHashMap<String, ObjectType>();
                    extensionTypesMap.put((String)id, (ObjectType)t);
                    this.types.put(e.getExtensionName(), extensionTypesMap);
                }
                this.extensionTypesInvertedIndex.put((String)id, e.getExtensionName());
            }));
        });
    }

    private Map<ObjectType, Set<ObjectType>> toSubTypesMap(Collection<SubTypesModel> subTypes) {
        return subTypes.stream().collect(Collectors.toMap(SubTypesModel::getBaseType, SubTypesModel::getSubTypes));
    }

    private Optional<ObjectType> getType(String typeId) {
        String extensionName = this.extensionTypesInvertedIndex.get(typeId);
        if (extensionName == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.types.get(extensionName).get(typeId));
    }

    public Set<ObjectType> getSubTypes(ObjectType type) {
        return this.mappings.stream().map(m -> m.getSubTypes((MetadataType)type)).flatMap(Collection::stream).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public Set<ObjectType> getAllBaseTypes() {
        return this.mappings.stream().map(mapping -> mapping.getAllBaseTypes()).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public Optional<String> getDeclaringExtension(MetadataType type) {
        return MetadataTypeUtils.getTypeId((MetadataType)type).map(typeId -> this.extensionTypesInvertedIndex.get(typeId));
    }

    public final class TypeCatalogEntry {
        private String extensionName;
        private Set<ObjectType> types;
        private Map<ObjectType, Set<ObjectType>> subTypes;

        public TypeCatalogEntry(String extensionName, Set<ObjectType> types, Map<ObjectType, Set<ObjectType>> subTypes) {
            Objects.requireNonNull(extensionName, "extensionName cannot be null");
            this.extensionName = extensionName;
            this.types = types != null ? types : Collections.emptySet();
            this.subTypes = subTypes != null ? subTypes : Collections.emptyMap();
        }

        public String getExtensionName() {
            return this.extensionName;
        }

        public Set<ObjectType> getTypes() {
            return this.types;
        }

        public Map<ObjectType, Set<ObjectType>> getSubTypes() {
            return this.subTypes;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TypeCatalogEntry that = (TypeCatalogEntry)o;
            return this.extensionName.equals(that.extensionName);
        }

        public int hashCode() {
            return this.extensionName.hashCode();
        }
    }

    private static class SubTypesMappingContainer {
        private final Map<ObjectType, Set<ObjectType>> subTypesMapping;
        private final Map<String, Set<ObjectType>> subTypesById;

        SubTypesMappingContainer(Map<ObjectType, Set<ObjectType>> subTypesMapping) {
            this.subTypesMapping = subTypesMapping;
            this.subTypesById = subTypesMapping.entrySet().stream().map(entry -> new Pair<String, Set>(MetadataTypeUtils.getTypeId((MetadataType)((MetadataType)entry.getKey())).orElse(null), (Set)entry.getValue())).filter(p -> p.getFirst() != null).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond, (k, v) -> k, LinkedHashMap::new));
        }

        Collection<ObjectType> getSubTypes(MetadataType type) {
            Collection subTypes = MetadataTypeUtils.getTypeId((MetadataType)type).map(this.subTypesById::get).orElse(this.subTypesMapping.get(type));
            return subTypes != null ? Collections.unmodifiableCollection(subTypes) : Collections.emptyList();
        }

        List<ObjectType> getSuperTypes(MetadataType type) {
            LinkedList types = new LinkedList();
            this.subTypesMapping.entrySet().stream().filter(entry -> ((Set)entry.getValue()).contains(type)).forEach(entry -> {
                types.add((ObjectType)entry.getKey());
                types.addAll(this.getSuperTypes((MetadataType)entry.getKey()));
            });
            return Collections.unmodifiableList(types);
        }

        boolean containsBaseType(ObjectType type) {
            return MetadataTypeUtils.getTypeId((MetadataType)type).map(this.subTypesById::get).orElse(this.subTypesMapping.get(type)) != null;
        }

        List<ObjectType> getAllSubTypes() {
            return this.subTypesMapping.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        }

        Set<ObjectType> getAllBaseTypes() {
            return this.subTypesMapping.keySet();
        }
    }
}

