/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.api.component.location;

import com.google.common.collect.ImmutableSet;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.mule.tooling.client.api.component.location.ComponentLocation;
import org.mule.tooling.client.api.component.location.SourceCodeLocation;

public class ArtifactComponentLocations
implements Serializable {
    private final Set<ComponentLocation> componentLocations;
    private final Map<SourceCodeLocation, ComponentLocation> sourceCodeLocationToComponentLocation = new HashMap<SourceCodeLocation, ComponentLocation>();
    private final Map<String, ComponentLocation> pathToComponentLocation = new HashMap<String, ComponentLocation>();

    public ArtifactComponentLocations(Set<ComponentLocation> componentLocations) {
        this.componentLocations = ImmutableSet.copyOf(componentLocations);
        componentLocations.forEach(componentLocation -> {
            componentLocation.getSourceCodeLocation().ifPresent(sourceCodeLocation -> this.sourceCodeLocationToComponentLocation.put((SourceCodeLocation)sourceCodeLocation, (ComponentLocation)componentLocation));
            this.pathToComponentLocation.put(componentLocation.getLocation(), (ComponentLocation)componentLocation);
        });
    }

    public Set<ComponentLocation> getComponentLocations() {
        return this.componentLocations;
    }

    public ComponentLocation getBySourceCodeLocation(SourceCodeLocation sourceCodeLocation) {
        return this.sourceCodeLocationToComponentLocation.get(sourceCodeLocation);
    }

    public ComponentLocation getByLocation(String location) {
        return this.pathToComponentLocation.get(location);
    }
}

