/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.persistence;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.mule.tooling.client.api.extension.model.ErrorModel;
import org.mule.tooling.client.internal.persistence.ErrorModelToIdentifierSerializer;

public class ErrorModelToIdentifierTypeAdapter
extends TypeAdapter<ErrorModel> {
    public static final String TYPE = "type";
    public static final String NAMESPACE = "namespace";
    private Map<String, ErrorModel> errorModelRepository = new HashMap<String, ErrorModel>();

    public ErrorModelToIdentifierTypeAdapter(Map<String, ErrorModel> errorModelMap) {
        this.errorModelRepository = errorModelMap;
    }

    public void write(JsonWriter out, ErrorModel value) throws IOException {
        out.value(ErrorModelToIdentifierSerializer.serialize(value));
    }

    public ErrorModel read(JsonReader in) throws IOException {
        String errorIdentifier;
        try {
            errorIdentifier = in.nextString();
        }
        catch (IllegalStateException e) {
            JsonObject error = new JsonParser().parse(in).getAsJsonObject();
            String type = error.get(TYPE).getAsString();
            String namespace = error.get(NAMESPACE).getAsString();
            errorIdentifier = namespace + ":" + type;
        }
        return ErrorModelToIdentifierSerializer.deserialize(errorIdentifier, this.errorModelRepository);
    }
}

