/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.persistence;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

abstract class KindEnrichedTypeAdapter<T>
extends TypeAdapter<T> {
    protected static final String KIND = "kind";
    protected final TypeAdapterFactory typeAdapterFactory;
    protected final Gson gson;

    public KindEnrichedTypeAdapter(TypeAdapterFactory typeAdapterFactory, Gson gson) {
        this.typeAdapterFactory = typeAdapterFactory;
        this.gson = gson;
    }

    public void write(JsonWriter out, T value) throws IOException {
        String kind = this.getKind(value);
        JsonObject json = this.getDelegateAdapter(kind).toJsonTree(value).getAsJsonObject();
        json.addProperty(KIND, kind);
        this.gson.toJson((JsonElement)json, out);
    }

    protected abstract String getKind(T var1);

    public T read(JsonReader in) throws IOException {
        JsonObject json = new JsonParser().parse(in).getAsJsonObject();
        if (!json.has(KIND)) {
            throw new IllegalArgumentException("Invalid json. Property kind wasn't specified");
        }
        String kind = json.get(KIND).getAsString();
        return (T)this.getDelegateAdapter(kind).fromJsonTree((JsonElement)json);
    }

    protected abstract TypeAdapter<T> getDelegateAdapter(String var1);
}

