/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.api.artifact.ast;

import static java.util.Optional.ofNullable;

import org.mule.tooling.client.api.artifact.dsl.DslElementSyntax;

import java.util.Optional;

/**
 * Object containing information about the creation of the owning object.
 *
 * @since 1.4
 */
public class ComponentGenerationInformation {

  private final DslElementSyntax syntax;

  public ComponentGenerationInformation(DslElementSyntax syntax) {
    this.syntax = syntax;
  }

  /**
   * @return the information about the XML representation of the owning component, if available.
   */
  public Optional<DslElementSyntax> getSyntax() {
    return ofNullable(syntax);
  }

}
