/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.api.cache;

/**
 * Factory for {@link CacheStorage}.
 *
 * @since 1.3.0
 */
public interface CacheStorageFactory {

  /**
   * Create a {@link CacheStorage}
   *
   * @param context a {@link CacheStorageFactoryContext} with information used to build a {@link CacheStorage}
   * @return {@link CacheStorage}.
   */
  CacheStorage createCacheStorage(CacheStorageFactoryContext context);

}
