/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.api.component;

import org.mule.tooling.client.api.types.UnknownType;

/**
 * Declares different types of component based on its common characteristics.
 *
 * @since 1.0
 */
public class ComponentType extends UnknownType {

  private boolean flow = false;
  private boolean source = false;
  private boolean operation = false;
  private boolean router = false;
  private boolean scope = false;
  private boolean intercepting = false;
  private boolean processor = false;
  private boolean errorHandling = false;
  private boolean onError = false;

  private ComponentType() {}

  public ComponentType(String name) {
    super(name);
  }

  public static ComponentType flowComponentType(String value) {
    ComponentType type = new ComponentType(value);
    type.flow = true;
    return type;
  }

  public static ComponentType sourceComponentType(String value) {
    ComponentType type = new ComponentType(value);
    type.source = true;
    return type;
  }

  public static ComponentType operationComponentType(String value) {
    ComponentType type = new ComponentType(value);
    type.operation = true;
    return type;
  }

  public static ComponentType routerComponentType(String value) {
    ComponentType type = new ComponentType(value);
    type.router = true;
    return type;
  }

  public static ComponentType scopeComponentType(String value) {
    ComponentType type = new ComponentType(value);
    type.scope = true;
    return type;
  }

  public static ComponentType interceptingComponentType(String value) {
    ComponentType type = new ComponentType(value);
    type.intercepting = true;
    return type;
  }

  public static ComponentType processorComponentType(String value) {
    ComponentType type = new ComponentType(value);
    type.processor = true;
    return type;
  }

  public static ComponentType errorHandlingComponentType(String value) {
    ComponentType type = new ComponentType(value);
    type.errorHandling = true;
    return type;
  }

  public static ComponentType onErrorComponentType(String value) {
    ComponentType type = new ComponentType(value);
    type.onError = true;
    return type;
  }

  public boolean isFlow() {
    return flow;
  }

  public boolean isErrorHandling() {
    return errorHandling;
  }

  public boolean isIntercepting() {
    return intercepting;
  }

  public boolean isOnError() {
    return onError;
  }

  public boolean isOperation() {
    return operation;
  }

  public boolean isProcessor() {
    return processor;
  }

  public boolean isRouter() {
    return router;
  }

  public boolean isScope() {
    return scope;
  }

  public boolean isSource() {
    return source;
  }

}
