/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.api.configuration.agent.proxy;

import static java.lang.String.format;
import static org.apache.commons.lang3.ClassUtils.getShortClassName;
import static org.mule.tooling.client.internal.util.Preconditions.checkArgument;

/**
 * Basic implementation of a {@link ProxyConfig}. Instances can only be obtained through a {@link ProxyConfigBuilder}.
 */
class DefaultProxyConfig implements ProxyConfig {

  private String host;
  private Integer port;

  DefaultProxyConfig(String host, Integer port) {
    checkArgument(host != null, "Host must be not null");

    this.host = host;
    this.port = port;
  }

  @Override
  public String getHost() {
    return host;
  }

  @Override
  public Integer getPort() {
    return port;
  }

  @Override
  public String toString() {
    return format("%s{host=%s,port=%s}", getShortClassName(this.getClass()), host, port);
  }
}
