/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.api.datasense;

import static java.lang.String.format;
import static org.apache.commons.lang3.ClassUtils.getShortClassName;
import org.mule.tooling.client.internal.datasense.DataSenseResolutionScopeVisitor;

/**
 * Resolves data sense at application level.
 *
 * @since 1.0
 */
public class ApplicationResolutionScope implements DataSenseResolutionScope {

  @Override
  public String toString() {
    return format("%s{}", getShortClassName(this.getClass()));
  }

  @Override
  public void accept(DataSenseResolutionScopeVisitor visitor) {
    visitor.visit(this);
  }

}
