/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.api.datasense;

import org.mule.metadata.api.model.MetadataType;
import org.mule.tooling.client.api.component.location.Location;

import java.util.List;
import java.util.Optional;

import static java.util.Optional.ofNullable;

public class DataSenseElementInfo {

  private MetadataType input;
  private MetadataType output;
  private MetadataType income;
  private MetadataType expected;
  private MetadataType actualInput;
  private MetadataType actualOutput;
  private MetadataType expectedInput;
  private MetadataType expectedOutput;
  private MetadataType result;
  private List<String> messages;
  private Location location;
  private List<DataSenseNotification> notifications;

  public Location getLocation() {
    return location;
  }

  public Optional<MetadataType> getInput() {
    return ofNullable(input);
  }

  public Optional<MetadataType> getOutput() {
    return ofNullable(output);
  }

  public Optional<MetadataType> getIncoming() {
    return ofNullable(income);
  }

  public Optional<MetadataType> getExpected() {
    return ofNullable(expected);
  }

  public Optional<MetadataType> getActualInput() {
    return ofNullable(actualInput);
  }

  public Optional<MetadataType> getActualOutput() {
    return ofNullable(actualOutput);
  }

  public Optional<MetadataType> getExpectedInput() {
    return ofNullable(expectedInput);
  }

  public Optional<MetadataType> getExpectedOutput() {
    return ofNullable(expectedOutput);
  }

  public Optional<MetadataType> getResult() {
    return ofNullable(result);
  }

  public List<String> getMessages() {
    return messages;
  }

  public List<DataSenseNotification> getDataSenseNotifications() {
    return notifications;
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {

    DataSenseElementInfo dataSenseElementInfo = new DataSenseElementInfo();

    public Builder withLocation(Location location) {
      dataSenseElementInfo.location = location;
      return this;
    }

    public Builder withInput(MetadataType input) {
      dataSenseElementInfo.input = input;
      return this;
    }

    public Builder withOutput(MetadataType output) {
      dataSenseElementInfo.output = output;
      return this;
    }

    public Builder withIncoming(MetadataType income) {
      dataSenseElementInfo.income = income;
      return this;
    }

    public Builder withExpected(MetadataType expected) {
      dataSenseElementInfo.expected = expected;
      return this;
    }

    public Builder withActualInput(MetadataType actualInput) {
      dataSenseElementInfo.actualInput = actualInput;
      return this;
    }

    public Builder withActualOutput(MetadataType actualOutput) {
      dataSenseElementInfo.actualOutput = actualOutput;
      return this;
    }

    public Builder withExpectedInput(MetadataType expectedInput) {
      dataSenseElementInfo.expectedInput = expectedInput;
      return this;
    }

    public Builder withExpectedOutput(MetadataType expectedOutput) {
      dataSenseElementInfo.expectedOutput = expectedOutput;
      return this;
    }

    public Builder withResult(MetadataType result) {
      dataSenseElementInfo.result = result;
      return this;
    }

    public Builder withMessages(List<String> messages) {
      dataSenseElementInfo.messages = messages;
      return this;
    }

    public Builder withNotifications(List<DataSenseNotification> notifications) {
      dataSenseElementInfo.notifications = notifications;
      return this;
    }

    public DataSenseElementInfo build() {
      return dataSenseElementInfo;
    }
  }
}
