/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.api.dataweave;

/**
 * Representation of a DataWeave preview response.
 *
 * @since 1.0
 */
public class DataWeavePreviewResponse {

  /**
   * If execution was successful or not.
   */
  private boolean valid;

  /**
   * Preview result content.
   */
  private String result;

  /**
   * Preview result media type.
   */
  private String mediaType;

  /**
   * Error message for not successful execution.
   */
  private String errorMessage;

  public String getErrorMessage() {
    return errorMessage;
  }

  public void setErrorMessage(String errorMessage) {
    this.errorMessage = errorMessage;
  }

  public String getMediaType() {
    return mediaType;
  }

  public void setMediaType(String mediaType) {
    this.mediaType = mediaType;
  }

  public String getResult() {
    return result;
  }

  public void setResult(String result) {
    this.result = result;
  }

  public boolean isValid() {
    return valid;
  }

  public void setValid(boolean valid) {
    this.valid = valid;
  }

  public static Builder builder() {
    return new Builder();
  }

  /**
   * Builder for creating {@link DataWeavePreviewResponse} objects.
   */
  public static class Builder {

    private DataWeavePreviewResponse instance;

    private Builder() {
      instance = new DataWeavePreviewResponse();
    }

    public Builder valid(Boolean isValid) {
      instance.setValid(isValid);
      return this;
    }

    public Builder result(String result) {
      instance.setResult(result);
      return this;
    }

    public Builder mediaType(String mediaType) {
      instance.setMediaType(mediaType);
      return this;
    }

    public Builder errorMessage(String errorMessage) {
      instance.setErrorMessage(errorMessage);
      return this;
    }

    public DataWeavePreviewResponse build() {
      return instance;
    }
  }
}
