/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.api.declaration.session;

import org.mule.runtime.app.declaration.api.ElementDeclaration;
import org.mule.tooling.client.api.cache.CacheStorage;
import org.mule.tooling.client.api.cache.CacheStorageSerializer;
import org.mule.tooling.client.api.metadata.ComponentMetadataTypesDescriptor;
import org.mule.tooling.client.api.metadata.MetadataResult;

/**
 * Contains all methods related to the internal caches being used by the {@link DeclarationSession}
 *
 * @since 1.4.0
 */
public interface DeclarationSessionCacheService {

  /**
   * Return the {@link CacheStorageSerializer} being used by internal caches to serialize and deserialize the keys and values
   * stored in the {@link org.mule.tooling.client.api.cache.CacheStorage}
   *
   * @return the {@link CacheStorageSerializer} used by the {@link DeclarationSession}
   */
  CacheStorageSerializer getSerializer();

  /**
   * Invalidate all entries that are linked with the global element that has the given name. This means that all results stored in
   * the cache computed from any {@link ElementDeclaration} that referenced a global element with the received name will be
   * removed.
   *
   * This method would iterate over the list of keys stored in cache and remove one by one if they match with a partial key. This
   * has impact in performance and memory if the {@link CacheStorage#getAllKeys()} doesn't implement the {@link java.util.Set}
   * with streaming support.
   * <p>
   * For example: If the global element name corresponds to a Configuration, then, all
   * {@link MetadataResult<ComponentMetadataTypesDescriptor>} and
   * {@link org.mule.tooling.client.api.value.resolver.ValueResolverResult} obtained from any
   * {@link org.mule.runtime.app.declaration.api.OperationElementDeclaration} or
   * {@link org.mule.runtime.app.declaration.api.SourceElementDeclaration} that referenced this config, will be removed.
   *
   * @param globalElementName
   */
  void invalidateDependencies(String globalElementName);

}
