/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.api.descriptors.dependency;

import java.io.Serializable;
import java.util.Objects;

/**
 * A Maven exclusion model.
 *
 * @since 1.4.0
 */
public class Exclusion implements Serializable, Cloneable {

  private String artifactId;
  private String groupId;

  public Exclusion() {}

  public Exclusion clone() {
    try {
      Exclusion copy = (Exclusion) super.clone();

      return copy;
    } catch (Exception e) {
      throw (RuntimeException) (new UnsupportedOperationException(this.getClass().getName() + " does not support clone()"))
          .initCause(e);
    }
  }

  public String getArtifactId() {
    return this.artifactId;
  }

  public String getGroupId() {
    return this.groupId;
  }

  public void setArtifactId(String artifactId) {
    this.artifactId = artifactId;
  }

  public void setGroupId(String groupId) {
    this.groupId = groupId;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof Exclusion)) {
      return false;
    }

    Exclusion other = (Exclusion) o;
    return Objects.equals(other.artifactId, this.artifactId)
        && Objects.equals(other.groupId, this.groupId);
  }

  @Override
  public int hashCode() {
    int result = artifactId != null ? artifactId.hashCode() : 0;
    result = 31 * result + (groupId != null ? groupId.hashCode() : 0);
    return result;
  }
}
