/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.api.error;

import java.util.Collection;

/**
 * A container for all error types available for an artifact.
 *
 * @since 1.4
 */
public class ErrorTypeRepository {

  private final Collection<ErrorType> errorTypes;
  private final Collection<ErrorType> internalErrorTypes;
  private final Collection<String> errorNamespaces;

  public ErrorTypeRepository(Collection<ErrorType> errorTypes,
                             Collection<ErrorType> internalErrorTypes,
                             Collection<String> errorNamespaces) {
    this.errorTypes = errorTypes;
    this.internalErrorTypes = internalErrorTypes;
    this.errorNamespaces = errorNamespaces;
  }

  /**
   * Returns the collection of current error namespaces.
   *
   * @return a collection of all present namespaces
   */
  public Collection<String> getErrorNamespaces() {
    return errorNamespaces;
  }

  /**
   * @return all catcheable errorTypes available for general use.
   */
  public Collection<ErrorType> getErrorTypes() {
    return errorTypes;
  }

  /**
   * @return all un-catcheable errorTypes.
   */
  public Collection<ErrorType> getInternalErrorTypes() {
    return internalErrorTypes;
  }
}
