/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.api.exception;

import org.mule.api.annotation.NoExtend;

/**
 * Configuration missing for accessing Tooling REST API so {@link org.mule.tooling.client.api.ToolingRuntimeClient} cannot resolve
 * the operation and this exception will be thrown.
 *
 * @since 1.0
 */
@NoExtend
public class MissingToolingConfigurationException extends ToolingException {

  public MissingToolingConfigurationException(String message) {
    super(message);
  }
}
