/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.api.extension.model;

import org.mule.tooling.client.api.types.UnknownType;

/**
 * Represents the types of support that a given component can provide regarding expressions.
 *
 * @since 1.0
 */
public class ExpressionSupport extends UnknownType {

  private boolean supported = false;
  private boolean notSupported = false;
  private boolean required = false;

  // Just needed in order to serialize this object
  private ExpressionSupport() {}

  public ExpressionSupport(String value) {
    super(value);
  }

  public static ExpressionSupport supportedExpressionSupport(String value) {
    ExpressionSupport expressionSupport = new ExpressionSupport(value);
    expressionSupport.supported = true;
    return expressionSupport;
  }

  public static ExpressionSupport notSupportedExpressionSupport(String value) {
    ExpressionSupport expressionSupport = new ExpressionSupport(value);
    expressionSupport.notSupported = true;
    return expressionSupport;
  }

  public static ExpressionSupport requiredExpressionSupport(String value) {
    ExpressionSupport expressionSupport = new ExpressionSupport(value);
    expressionSupport.required = true;
    return expressionSupport;
  }

  /**
   * @return {@code true} if expressions are required but not enforced. Static values are accepted too.
   */
  public boolean isSupported() {
    return supported;
  }

  /**
   * @return {@code true} if expressions not allowed. Static values only
   */
  public boolean isNotSupported() {
    return notSupported;
  }

  /**
   * @return {@code true} if requires expressions. Static values are not supported
   */
  public boolean isRequired() {
    return required;
  }

  @Override
  public String toString() {
    return getValue();
  }
}
