/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.api.extension.model;

import static java.util.Optional.ofNullable;
import static org.apache.commons.lang3.builder.EqualsBuilder.reflectionEquals;
import static org.apache.commons.lang3.builder.HashCodeBuilder.reflectionHashCode;

import java.util.Optional;

import org.apache.commons.lang3.builder.ToStringBuilder;

/**
 * Contains directives about how this parameter should be shown in the UI.
 *
 * @since 1.0
 */
public class LayoutModel {

  public static final int DEFAULT_ORDER = -1;

  private boolean password = false;
  private boolean text = false;
  private boolean query = false;
  private Integer order = null;
  private String tabName = null;

  // Just needed in order to serialize this object
  private LayoutModel() {}

  public LayoutModel(String tabName, Integer order, boolean password, boolean text, boolean query) {
    this.tabName = tabName;
    this.order = order;
    this.password = password;
    this.text = text;
    this.query = query;
  }

  /**
   * @return Whether this model represents a password and should be masked in the UI
   */
  public boolean isPassword() {
    return password;
  }

  /**
   * @return Whether this model should use a multi line string editor in the UI or not
   */
  public boolean isText() {
    return text;
  }

  /**
   * @return Whether this model represents a query and should be treated accordingly in the UI
   */
  public boolean isQuery() {
    return query;
  }

  /**
   * @return The order of the model within its group.
   */
  public Optional<Integer> getOrder() {
    return ofNullable(order);
  }

  /**
   * @return The tab element name where the model and its group it's going to be located.
   */
  public Optional<String> getTabName() {
    return ofNullable(tabName);
  }

  @Override
  public int hashCode() {
    return reflectionHashCode(this);
  }

  public boolean equals(Object obj) {
    return reflectionEquals(this, obj);
  }

  public String toString() {
    return ToStringBuilder.reflectionToString(this);
  }

}

