/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.api.extension.model;

/**
 * Contains directives regarding semantics for the DSL which supports one given owning element.
 *
 * @since 1.0
 */
public class ParameterDslConfiguration {

  private boolean allowInlineDefinition = true;
  private boolean allowTopLevelDefinition = false;
  private boolean allowReferences = true;

  // Just needed in order to serialize this object
  private ParameterDslConfiguration() {}

  public ParameterDslConfiguration(boolean allowInlineDefinition, boolean allowTopLevelDefinition, boolean allowReferences) {
    this.allowInlineDefinition = allowInlineDefinition;
    this.allowTopLevelDefinition = allowTopLevelDefinition;
    this.allowReferences = allowReferences;
  }

  /**
   * @return whether the associated element should support inline definition as child element
   */
  public boolean allowsInlineDefinition() {
    return allowInlineDefinition;
  }

  /**
   * @return whether the associated element should support being defined as a top level definition
   */
  public boolean allowTopLevelDefinition() {
    return allowTopLevelDefinition;
  }

  /**
   * @return whether the associated element should support registry references
   */
  public boolean allowsReferences() {
    return allowReferences;
  }

}
