/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.api.extension.model;

import static java.util.Collections.unmodifiableList;
import static java.util.stream.Collectors.toList;

import org.mule.tooling.client.api.extension.model.parameter.ParameterGroupModel;
import org.mule.tooling.client.api.extension.model.parameter.ParameterModel;

import java.util.List;
import java.util.Optional;

/**
 * Common interface for all model items that declare parameters.
 *
 * @since 1.4
 */
public interface ParameterizedModel {

  /**
   * @return a {@Link List} of {@link ParameterGroupModel groups}
   */
  List<ParameterGroupModel> getParameterGroupModels();

  Optional<ParameterGroupModel> getParameterGroupModel(String name);

  /**
   * Returns all the {@link ParameterModel parameters} on all groups.
   *
   * @return a flattened list of all the parameters in this model
   */
  default List<ParameterModel> getAllParameterModels() {
    return unmodifiableList(getParameterGroupModels().stream()
        .flatMap(g -> g.getParameterModels().stream())
        .collect(toList()));
  }

}
