/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.api.message.history;

/**
 * Immutable implementation for {@link Message}.
 *
 * @since 1.0
 */
public class ImmutableMessage implements Message {

  private TypedValue attributes;
  private TypedValue payload;

  private ImmutableMessage() {}

  /**
   * Creates a builder for the {@link ImmutableMessage} object.
   *
   * @return a new builder.
   */
  public static Builder builder() {
    return new Builder();
  }

  @Override
  public TypedValue getAttributes() {
    return attributes;
  }

  @Override
  public TypedValue getPayload() {
    return payload;
  }

  /**
   * Builder for creating {@link ImmutableMessage} objects.
   */
  public static class Builder {

    private ImmutableMessage instance;

    private Builder() {
      instance = new ImmutableMessage();
    }

    public Builder attributes(TypedValue attributes) {
      instance.attributes = attributes;
      return this;
    }

    public Builder payload(TypedValue payload) {
      instance.payload = payload;
      return this;
    }

    public ImmutableMessage build() {
      return instance;
    }
  }

}
