/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.api.metadata.type;

import static java.util.Collections.emptySet;

import org.mule.metadata.api.model.ObjectType;

import java.util.Set;

/**
 * DTO that references all the subTypes for a given objectType in the context of a set of extension models..
 */
public class ObjectTypeHierarchy {

  private String extensionName;
  private ObjectType type;
  private Set<SubTypeMapping> subTypeMappings = emptySet();

  public String getExtensionName() {
    return extensionName;
  }

  public void setExtensionName(String extensionName) {
    this.extensionName = extensionName;
  }

  public ObjectType getType() {
    return type;
  }

  public void setType(ObjectType type) {
    this.type = type;
  }

  public Set<SubTypeMapping> getSubTypeMappings() {
    return subTypeMappings;
  }

  public void setSubTypeMappings(Set<SubTypeMapping> subTypeMappings) {
    this.subTypeMappings = subTypeMappings;
  }

  @Override
  public String toString() {
    return "ObjectTypeHierarchy{" +
        "extensionName='" + extensionName + '\'' +
        ", type='" + type + '\'' +
        ", subTypeMappings=" + subTypeMappings +
        '}';
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }

    ObjectTypeHierarchy that = (ObjectTypeHierarchy) o;

    if (!extensionName.equals(that.extensionName)) {
      return false;
    }
    return type.equals(that.type);
  }

  @Override
  public int hashCode() {
    int result = extensionName.hashCode();
    result = 31 * result + type.hashCode();
    return result;
  }
}
