/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.api.value;

import static java.util.Collections.unmodifiableSet;

import java.util.Set;

/**
 * Represents a possible and valid value for a parameter.
 * <p>
 * Also this {@link Value} can be composed by other {@link Value Options} to form a composed option.
 *
 * @since 1.0
 */
public class Value {

  private String id;
  private String displayName;
  private Set<Value> children;
  private String partName;

  private Value() {}

  public Value(String id, String displayName, String partName, Set<Value> children) {
    this.id = id;
    this.displayName = displayName;
    this.partName = partName;
    this.children = unmodifiableSet(children);
  }

  /**
   * @return identifier for the current option
   */
  public String getId() {
    return id;
  }

  /**
   * @return human readable name to use when displaying the option
   */
  public String getDisplayName() {
    return displayName;
  }

  /**
   * @return the child {@link Value values} that form a composed {@link Value}.
   */
  public Set<Value> getChilds() {
    return children;
  }

  /**
   * @return the name of the part which this {@link Value} is from
   */
  public String getPartName() {
    return partName;
  }
}
