/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.api.value.provider;

import static java.util.Arrays.asList;
import org.mule.tooling.client.api.component.location.Location;

import java.util.List;

/**
 * Simple POJO to encapsulate the data to be disposed from the Cache.
 *
 * @since 1.3.0
 */
public class ValueProviderDisposeRequest {

  private final Location location;
  private final List<String> parameterNames;

  public static ValueProviderDisposeRequestBuilder disposeValuesOn(Location location) {
    return new ValueProviderDisposeRequestBuilder(location);
  }

  private ValueProviderDisposeRequest(Location location, String... parameterNames) {
    this.location = location;
    this.parameterNames = asList(parameterNames);
  }

  public Location getLocation() {
    return location;
  }

  public List<String> getParameterNames() {
    return parameterNames;
  }

  public static class ValueProviderDisposeRequestBuilder {

    private Location location;

    private ValueProviderDisposeRequestBuilder(Location location) {
      this.location = location;
    }

    public ValueProviderDisposeRequest forParameters(String... parameterNames) {
      return new ValueProviderDisposeRequest(this.location, parameterNames);
    }

    public ValueProviderDisposeRequest forAllParameters() {
      return new ValueProviderDisposeRequest(this.location);
    }
  }

}
