/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.api.value.provider;

import org.mule.tooling.client.api.feature.Action;
import org.mule.tooling.client.api.feature.Feature;
import org.mule.tooling.client.api.value.ValueResult;

/**
 * Provides the capability of resolve the {@link org.mule.tooling.client.api.value.Value values} for any Value Provider capable
 * element in a Mule App.
 *
 * @since 1.0
 */
public interface ValueProviderService {

  /**
   * Resolves the {@link org.mule.tooling.client.api.value.Value values} for a element's value provider located in the given
   * {@link org.mule.tooling.client.api.component.location.Location}.
   *
   * @param valueProviderRequest Request to be able to execute Value Provider resolution.
   * @return the {@link ValueResult result} of the resolving of the values.
   * @see ValueResult
   */
  ValueResult getValues(ValueProviderRequest valueProviderRequest);


  /**
   * If supported by the {@link org.mule.tooling.client.api.ToolingRuntimeClient} implementation will return a
   * {@link Feature<Action>} to do the dispose of stored Values, for the given location.
   * </p>
   * This should be called when external changes on remote system are made and the values provided have to be recalculated from
   * scratch.
   *
   * @return {@link Feature<Action>} to execute an {@link Action} for the location of the component that provided the values to be
   *         cleared.
   *
   * @since 1.3.0
   */
  Feature<Action<ValueProviderDisposeRequest>> disposeCachedValues();

}
