/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.api.value.resolver;

/**
 * Represents a possible and valid value for a parameter. These are provided by calling the Value Resolver on a connector's
 * component.
 *
 * @since 1.4.0
 */
public class ResolvedValue {

  private String id;
  private String displayName;

  private ResolvedValue() {}

  public ResolvedValue(String id, String displayName) {
    this.id = id;
    this.displayName = displayName;
  }

  /**
   * @return identifier for the current option
   */
  public String getId() {
    return id;
  }

  /**
   * @return human readable name to use when displaying the option
   */
  public String getDisplayName() {
    return displayName;
  }

}
