/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.internal.cache;

import org.mule.tooling.client.api.cache.CacheStorageFactoryContext;
import org.mule.tooling.client.api.cache.CacheStorageSerializer;

import java.net.URL;
import java.util.Map;

public class DefaultCacheStorageFactoryContext implements CacheStorageFactoryContext {

  private String toolingArtifactId;
  private URL artifactContentUrl;
  private Map<String, String> toolingArtifactProperties;
  private CacheStorageSerializer storageSerializer;

  public DefaultCacheStorageFactoryContext(String toolingArtifactId,
                                           URL artifactContentUrl,
                                           Map<String, String> toolingArtifactProperties,
                                           CacheStorageSerializer storageSerializer) {
    this.toolingArtifactId = toolingArtifactId;
    this.artifactContentUrl = artifactContentUrl;
    this.toolingArtifactProperties = toolingArtifactProperties;
    this.storageSerializer = storageSerializer;
  }

  @Override
  public String getToolingArtifactId() {
    return toolingArtifactId;
  }

  @Override
  public URL getArtifactContentUrl() {
    return artifactContentUrl;
  }

  @Override
  public Map<String, String> getToolingArtifactProperties() {
    return toolingArtifactProperties;
  }

  @Override
  public CacheStorageSerializer getStorageSerializer() {
    return storageSerializer;
  }
}
