/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.internal.concurrency;

import static java.lang.System.getProperty;
import org.mule.maven.client.internal.MuleMavenConcurrentLocalRepository;

/**
 * Tooling implementation for {@link MuleMavenConcurrentLocalRepository}.
 */
public class ToolingMavenConcurrentLocalRepository implements MuleMavenConcurrentLocalRepository {

  /**
   * When this property is set to true, the Maven Concurrent Local Repository will be enabled.
   */
  private static String TOOLING_CONCURRENT_LOCAL_REPOSITORY_ENABLED = "tooling.concurrent.local.repository.enabled";
  private Boolean concurrentLocalRepositoryEnabled =
      Boolean.valueOf(getProperty(TOOLING_CONCURRENT_LOCAL_REPOSITORY_ENABLED, "true"));

  @Override
  public boolean isConcurrentLocalRepositoryEnabled() {
    return concurrentLocalRepositoryEnabled;
  }
}
