/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.internal.configuration.ssl;

import static java.lang.String.format;
import static java.util.Objects.requireNonNull;
import static org.apache.commons.lang3.ClassUtils.getShortClassName;
import org.mule.tooling.client.api.configuration.ssl.KeyStoreConfig;

import java.io.File;

/**
 * Immutable implementation of {@link KeyStoreConfig}.
 *
 * @since 1.0
 */
public class ImmutableKeyStoreConfig implements KeyStoreConfig {

  private final File keyStoreFile;
  private final String keyStorePassword;

  /**
   * Creates an instance of this configuration.
   *
   * @param keyStoreFile     key store {@link File}.
   * @param keyStorePassword key store password.
   */
  public ImmutableKeyStoreConfig(File keyStoreFile, String keyStorePassword) {
    requireNonNull(keyStoreFile, "keyStoreFile cannot be null");
    requireNonNull(keyStorePassword, "keyStorePassword cannot be null");

    this.keyStoreFile = keyStoreFile;
    this.keyStorePassword = keyStorePassword;
  }

  @Override
  public File getKeyStoreFile() {
    return keyStoreFile;
  }

  @Override
  public String getKeyStorePassword() {
    return keyStorePassword;
  }

  @Override
  public String toString() {
    return format("%s{keyStoreFile=%s, keyStorePassword=%s}",
                  getShortClassName(this.getClass()), keyStoreFile.getAbsolutePath(), "****");
  }
}
