/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.internal.persistence;

import static java.util.Objects.requireNonNull;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.persistence.MetadataTypeGsonTypeAdapter;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;

import java.io.IOException;

/**
 * Decorator for {@link MetadataTypeGsonTypeAdapter} that handles null values.
 *
 * @since 1.0
 */
public class MetadataTypeGsonTypeAdapterWithNullSupport extends TypeAdapter<MetadataType> {

  private MetadataTypeGsonTypeAdapter delegate;

  public MetadataTypeGsonTypeAdapterWithNullSupport(MetadataTypeGsonTypeAdapter delegate) {
    requireNonNull(delegate, "delegate cannot be null");
    this.delegate = delegate;
  }

  @Override
  public void write(JsonWriter jsonWriter, MetadataType metadataType) throws IOException {
    if (metadataType != null) {
      delegate.write(jsonWriter, metadataType);
    } else {
      jsonWriter.nullValue();
    }
  }

  @Override
  public MetadataType read(JsonReader in) throws IOException {
    return delegate.read(in);
  }
}
