/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.internal.serialization;

/**
 * Serializer to communicate client API to the implementation.
 *
 * @since 1.2.0
 */
public interface Serializer {

  /**
   * Serializes the object into an String format.
   *
   * @param object to be serialized.
   * @return the output of the serialization as {@link String}.
   */
  String serialize(Object object);

  /**
   * Deserialzes the content to the object T.
   *
   * @param content serialized content.
   * @param <T>     the type of the object.
   * @return the object.
   */
  <T> T deserialize(String content);

}
