/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.internal.serialization;

import org.mule.metadata.api.annotation.TypeAnnotation;

/**
 * Test type annotation.
 */
public class TestMetadataFormatPropertiesAnnotation implements TypeAnnotation {

  public static final String NAME = "testTypeAnnotation";

  private String value;

  public TestMetadataFormatPropertiesAnnotation(String value) {
    this.value = value;
  }

  public String getValue() {
    return value;
  }

  @Override
  public String getName() {
    return NAME;
  }
}
