/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.api.exception;

import java.util.Arrays;
import java.util.Optional;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.mule.api.annotation.NoExtend;

@NoExtend
public class ToolingException
extends RuntimeException {
    private static final long serialVersionUID = -2219402190799099475L;
    private String rootCauseMessage;
    private String rootCauseType;
    private String[] rootCauseStackTrace;

    public ToolingException(String message) {
        super(message);
    }

    public ToolingException(Throwable cause) {
        super(ToolingException.buildMessage(Optional.empty(), ExceptionUtils.getStackTrace((Throwable)cause)), null);
        this.setRootCauseMessage(cause);
        this.setRootCauseType(cause);
        this.setRootCauseStackTrace(cause);
    }

    public ToolingException(String message, Throwable cause) {
        super(ToolingException.buildMessage(Optional.of(message), ExceptionUtils.getStackTrace((Throwable)cause)), null);
        this.setRootCauseMessage(cause);
        this.setRootCauseType(cause);
        this.setRootCauseStackTrace(cause);
    }

    protected static String buildMessage(Optional<String> message, String cause) {
        StringBuilder stringBuilder = new StringBuilder();
        message.ifPresent(stringBuilder::append);
        stringBuilder.append(System.lineSeparator());
        stringBuilder.append(cause);
        return stringBuilder.toString();
    }

    protected ToolingException(String message, String rootCauseMessage, String rootCauseType, String[] rootCauseStackTrace) {
        this(message);
        this.rootCauseMessage = rootCauseMessage;
        this.rootCauseType = rootCauseType;
        this.rootCauseStackTrace = rootCauseStackTrace;
    }

    @Override
    public String toString() {
        return "ToolingException{message='" + this.getMessage() + '\'' + System.lineSeparator() + (this.getCause() != null ? ", causeStackTrace='" + Arrays.toString(this.getCause().getStackTrace()) + '\'' + System.lineSeparator() : "") + ", rootCauseMessage='" + this.rootCauseMessage + '\'' + System.lineSeparator() + ", rootCauseType='" + this.rootCauseType + '\'' + System.lineSeparator() + ", rootCauseStackTrace='" + Arrays.toString(this.rootCauseStackTrace) + '\'' + '}';
    }

    private void setRootCauseMessage(Throwable cause) {
        this.rootCauseMessage = ExceptionUtils.getRootCauseMessage((Throwable)cause);
    }

    private void setRootCauseType(Throwable cause) {
        Throwable rootCause = ExceptionUtils.getRootCause((Throwable)cause);
        rootCause = rootCause == null ? cause : rootCause;
        this.rootCauseType = rootCause.getClass().getName();
    }

    private void setRootCauseStackTrace(Throwable cause) {
        this.rootCauseStackTrace = ExceptionUtils.getRootCauseStackTrace((Throwable)cause);
    }

    public String getRootCauseMessage() {
        return this.rootCauseMessage;
    }

    public String getRootCauseType() {
        return this.rootCauseType;
    }

    public String[] getRootCauseStackTrace() {
        return this.rootCauseStackTrace;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String message;
        private String rootCauseMessage;
        private String rootCauseType;
        private String[] rootCauseStackTrace;

        public Builder withMessage(String message) {
            this.message = message;
            return this;
        }

        public Builder withRootCauseMessage(String rootCauseMessage) {
            this.rootCauseMessage = rootCauseMessage;
            return this;
        }

        public Builder withRootCauseType(String rootCauseType) {
            this.rootCauseType = rootCauseType;
            return this;
        }

        public Builder withRootCauseStackTrace(String[] rootCauseStackTrace) {
            this.rootCauseStackTrace = rootCauseStackTrace;
            return this;
        }

        public ToolingException build() {
            return new ToolingException(this.message, this.rootCauseMessage, this.rootCauseType, this.rootCauseStackTrace);
        }
    }
}

