/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.api.extension.model.metadata;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.mule.tooling.client.api.extension.model.metadata.ResolverInformation;
import org.mule.tooling.client.internal.util.Preconditions;

public class TypeResolversInformationModel {
    private final String category;
    private final ResolverInformation outputResolver;
    private final ResolverInformation attributesResolver;
    private final ResolverInformation keysResolver;
    private final boolean partialTypeKeyResolver;
    private final Map<String, ResolverInformation> inputResolvers;

    public TypeResolversInformationModel(String category, Map<String, ResolverInformation> inputResolvers, ResolverInformation outputResolver, ResolverInformation attributesResolver, ResolverInformation keysResolver, boolean partialTypeKeyResolver) {
        Preconditions.checkArgument(StringUtils.isNotBlank((CharSequence)category), "A Category name is required for a group of resolvers");
        this.category = category;
        this.outputResolver = outputResolver;
        this.attributesResolver = attributesResolver;
        this.keysResolver = keysResolver;
        this.partialTypeKeyResolver = partialTypeKeyResolver;
        this.inputResolvers = inputResolvers;
    }

    public String getCategoryName() {
        return this.category;
    }

    public Optional<ResolverInformation> getOutputResolver() {
        return Optional.ofNullable(this.outputResolver);
    }

    public Optional<ResolverInformation> getAttributesResolver() {
        return Optional.ofNullable(this.attributesResolver);
    }

    public Optional<ResolverInformation> getKeysResolver() {
        return Optional.ofNullable(this.keysResolver);
    }

    public Optional<ResolverInformation> getParameterResolver(String parameterName) {
        return this.inputResolvers != null ? Optional.ofNullable(this.inputResolvers.get(parameterName)) : Optional.empty();
    }

    public Map<String, ResolverInformation> getParameterResolvers() {
        return this.inputResolvers != null ? Collections.unmodifiableMap(this.inputResolvers) : Collections.emptyMap();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeResolversInformationModel that = (TypeResolversInformationModel)o;
        return Objects.equals(this.category, that.category) && Objects.equals(this.inputResolvers, that.inputResolvers) && Objects.equals(this.outputResolver, that.outputResolver) && Objects.equals(this.keysResolver, that.keysResolver) && Objects.equals(this.attributesResolver, that.attributesResolver) && Objects.equals(this.partialTypeKeyResolver, that.partialTypeKeyResolver);
    }

    public int hashCode() {
        return Objects.hash(this.category, this.inputResolvers, this.outputResolver, this.keysResolver, this.attributesResolver, this.partialTypeKeyResolver);
    }

    public String toString() {
        return "TypeResolversInformationModel{category='" + this.category + '\'' + ", parameters=" + this.inputResolvers + ", outputResolver='" + this.outputResolver + '\'' + ", keysResolver='" + this.keysResolver + '\'' + ", attributesResolver='" + this.attributesResolver + '\'' + ", partialTypeKeyResolver='" + this.partialTypeKeyResolver + '\'' + '}';
    }
}

