/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.api.extension.model.construct;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.mule.tooling.client.api.extension.model.ComponentModel;
import org.mule.tooling.client.api.extension.model.DisplayModel;
import org.mule.tooling.client.api.extension.model.ErrorModel;
import org.mule.tooling.client.api.extension.model.StereotypeModel;
import org.mule.tooling.client.api.extension.model.connection.ConnectionProviderModel;
import org.mule.tooling.client.api.extension.model.deprecated.DeprecationModel;
import org.mule.tooling.client.api.extension.model.metadata.TypeResolversInformationModel;
import org.mule.tooling.client.api.extension.model.nested.NestableElementModel;
import org.mule.tooling.client.api.extension.model.parameter.ParameterGroupModel;
import org.mule.tooling.client.api.feature.Feature;

public class ConstructModel
implements ComponentModel {
    private String name;
    private String description;
    private List<ParameterGroupModel> parameterGroupModels;
    private DisplayModel displayModel;
    private StereotypeModel stereotype;
    private List<? extends NestableElementModel> nestedComponents;
    private boolean allowsTopLevelDefinition;
    private Set<ErrorModel> errorModels;
    private Feature<DeprecationModel> deprecationModel;
    private Feature<TypeResolversInformationModel> typeResolversInformationModel;
    private Set<String> semanticTerms;

    @Deprecated
    public ConstructModel(String name, String description, List<ParameterGroupModel> parameterGroupModels, DisplayModel displayModel, StereotypeModel stereotype, List<? extends NestableElementModel> nestedComponents, boolean allowsTopLevelDefinition, Set<ErrorModel> errorModels, DeprecationModel deprecationModel) {
        this(name, description, parameterGroupModels, displayModel, stereotype, nestedComponents, allowsTopLevelDefinition, errorModels, deprecationModel, null);
    }

    public ConstructModel(String name, String description, List<ParameterGroupModel> parameterGroupModels, DisplayModel displayModel, StereotypeModel stereotype, List<? extends NestableElementModel> nestedComponents, boolean allowsTopLevelDefinition, Set<ErrorModel> errorModels, DeprecationModel deprecationModel, TypeResolversInformationModel typeResolversInformationModel) {
        this(name, description, parameterGroupModels, displayModel, stereotype, nestedComponents, allowsTopLevelDefinition, errorModels, deprecationModel, typeResolversInformationModel, Collections.emptySet());
    }

    public ConstructModel(String name, String description, List<ParameterGroupModel> parameterGroupModels, DisplayModel displayModel, StereotypeModel stereotype, List<? extends NestableElementModel> nestedComponents, boolean allowsTopLevelDefinition, Set<ErrorModel> errorModels, DeprecationModel deprecationModel, TypeResolversInformationModel typeResolversInformationModel, Set<String> semanticTerms) {
        this.name = name;
        this.description = description;
        this.parameterGroupModels = parameterGroupModels;
        this.displayModel = displayModel;
        this.stereotype = stereotype;
        this.nestedComponents = nestedComponents;
        this.allowsTopLevelDefinition = allowsTopLevelDefinition;
        this.errorModels = errorModels;
        this.deprecationModel = Feature.enabled(deprecationModel);
        this.typeResolversInformationModel = Feature.enabled(typeResolversInformationModel);
        this.semanticTerms = new HashSet<String>(semanticTerms);
    }

    public boolean allowsTopLevelDeclaration() {
        return this.allowsTopLevelDefinition;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public List<ParameterGroupModel> getParameterGroupModels() {
        return this.parameterGroupModels;
    }

    @Override
    public Optional<DisplayModel> getDisplayModel() {
        return Optional.ofNullable(this.displayModel);
    }

    @Override
    public StereotypeModel getStereotype() {
        return this.stereotype;
    }

    @Override
    public List<? extends NestableElementModel> getNestedComponents() {
        return this.nestedComponents;
    }

    public boolean isAllowsTopLevelDefinition() {
        return this.allowsTopLevelDefinition;
    }

    @Override
    public Set<ErrorModel> getErrorModels() {
        return this.errorModels;
    }

    @Override
    public Feature<TypeResolversInformationModel> getTypeResolversInformationModel() {
        if (this.typeResolversInformationModel == null) {
            this.typeResolversInformationModel = Feature.disabled();
        }
        return this.typeResolversInformationModel;
    }

    public Feature<DeprecationModel> getDeprecationModel() {
        if (this.deprecationModel == null) {
            this.deprecationModel = Feature.disabled();
        }
        return this.deprecationModel;
    }

    @Override
    public Set<String> getSemanticTerms() {
        if (this.semanticTerms == null) {
            this.semanticTerms = Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.semanticTerms);
    }

    @Override
    public Optional<ParameterGroupModel> getParameterGroupModel(String name) {
        return this.parameterGroupModels.stream().filter(model -> model.getName().equals(name)).findFirst();
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        return this.getClass().isInstance(obj) && this.name.equals(((ConnectionProviderModel)obj).getName());
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

