/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.api.extension.model.connection;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.mule.tooling.client.api.extension.model.DisplayModel;
import org.mule.tooling.client.api.extension.model.ExternalLibraryModel;
import org.mule.tooling.client.api.extension.model.ParameterizedModel;
import org.mule.tooling.client.api.extension.model.StereotypeModel;
import org.mule.tooling.client.api.extension.model.connection.ConnectionManagementType;
import org.mule.tooling.client.api.extension.model.deprecated.DeprecationModel;
import org.mule.tooling.client.api.extension.model.parameter.ParameterGroupModel;
import org.mule.tooling.client.api.extension.model.semantic.HasSemanticTerms;
import org.mule.tooling.client.api.feature.Feature;

public class ConnectionProviderModel
implements ParameterizedModel,
HasSemanticTerms {
    private String name;
    private String description;
    private DisplayModel displayModel;
    private ConnectionManagementType connectionManagementType;
    private List<ParameterGroupModel> parameterGroupModels;
    private Set<ExternalLibraryModel> externalLibraryModels;
    private StereotypeModel stereotype;
    private boolean supportsConnectivityTesting = true;
    private Feature<DeprecationModel> deprecationModel;
    private Set<String> semanticTerms;

    private ConnectionProviderModel() {
    }

    public ConnectionProviderModel(String name, String description, DisplayModel displayModel, ConnectionManagementType connectionManagementType, boolean supportsConnectivityTesting, List<ParameterGroupModel> parameterGroupModels, Set<ExternalLibraryModel> externalLibraryModels, StereotypeModel stereotype, DeprecationModel deprecationModel) {
        this(name, description, displayModel, connectionManagementType, supportsConnectivityTesting, parameterGroupModels, externalLibraryModels, stereotype, deprecationModel, Collections.emptySet());
    }

    public ConnectionProviderModel(String name, String description, DisplayModel displayModel, ConnectionManagementType connectionManagementType, boolean supportsConnectivityTesting, List<ParameterGroupModel> parameterGroupModels, Set<ExternalLibraryModel> externalLibraryModels, StereotypeModel stereotype, DeprecationModel deprecationModel, Set<String> semanticTerms) {
        this.name = name;
        this.description = description;
        this.displayModel = displayModel;
        this.connectionManagementType = connectionManagementType;
        this.supportsConnectivityTesting = supportsConnectivityTesting;
        this.parameterGroupModels = parameterGroupModels;
        this.externalLibraryModels = externalLibraryModels;
        this.stereotype = stereotype;
        this.deprecationModel = Feature.enabled(deprecationModel);
        this.semanticTerms = new HashSet<String>(semanticTerms);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Optional<DisplayModel> getDisplayModel() {
        return Optional.ofNullable(this.displayModel);
    }

    public ConnectionManagementType getConnectionManagementType() {
        return this.connectionManagementType;
    }

    @Override
    public List<ParameterGroupModel> getParameterGroupModels() {
        return this.parameterGroupModels;
    }

    public Set<ExternalLibraryModel> getExternalLibraryModels() {
        return this.externalLibraryModels;
    }

    public StereotypeModel getStereotype() {
        return this.stereotype;
    }

    public boolean supportsConnectivityTesting() {
        return this.supportsConnectivityTesting;
    }

    public Feature<DeprecationModel> getDeprecationModel() {
        if (this.deprecationModel == null) {
            this.deprecationModel = Feature.disabled();
        }
        return this.deprecationModel;
    }

    @Override
    public Optional<ParameterGroupModel> getParameterGroupModel(String name) {
        return this.parameterGroupModels.stream().filter(model -> model.getName().equals(name)).findFirst();
    }

    @Override
    public Set<String> getSemanticTerms() {
        if (this.semanticTerms == null) {
            this.semanticTerms = Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.semanticTerms);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        return this.getClass().isInstance(obj) && this.name.equals(((ConnectionProviderModel)obj).getName());
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

