/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.api.extension.model.value;

import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.mule.api.annotation.NoInstantiate;
import org.mule.tooling.client.api.extension.model.parameter.ActingParameterModel;
import org.mule.tooling.client.api.feature.Feature;
import org.mule.tooling.client.internal.util.Preconditions;

@NoInstantiate
public class ValueProviderModel {
    private List<String> actingParameters;
    private Feature<List<ActingParameterModel>> parameters;
    private Integer partOrder;
    private String providerName;
    private Feature<String> providerId;
    private boolean requiresConfiguration;
    private boolean requiresConnection;
    private boolean isOpen;

    protected ValueProviderModel() {
    }

    public ValueProviderModel(List<String> actingParameters, boolean requiresConfiguration, boolean requiresConnection, boolean isOpen, Integer partOrder, String providerName, String providerId) {
        Preconditions.checkNotNull(actingParameters, "'actingParameters' can't be null");
        Preconditions.checkNotNull(partOrder, "'valueParts' can't be null");
        Preconditions.checkNotNull(providerName, "'providerName' can't be null");
        this.isOpen = isOpen;
        this.actingParameters = actingParameters;
        this.parameters = Feature.disabled();
        this.requiresConfiguration = requiresConfiguration;
        this.requiresConnection = requiresConnection;
        this.partOrder = partOrder;
        this.providerName = providerName;
        this.providerId = Feature.enabled(providerId);
    }

    public ValueProviderModel(List<String> actingParameters, List<ActingParameterModel> parameters, boolean requiresConfiguration, boolean requiresConnection, boolean isOpen, Integer partOrder, String providerName, String providerId) {
        Preconditions.checkNotNull(actingParameters, "'actingParameters' can't be null");
        Preconditions.checkNotNull(parameters, "'parameters' can't be null");
        Preconditions.checkNotNull(partOrder, "'valueParts' can't be null");
        Preconditions.checkNotNull(providerName, "'providerName' can't be null");
        this.isOpen = isOpen;
        this.actingParameters = actingParameters;
        this.parameters = Feature.enabled(parameters);
        this.requiresConfiguration = requiresConfiguration;
        this.requiresConnection = requiresConnection;
        this.partOrder = partOrder;
        this.providerName = providerName;
        this.providerId = Feature.enabled(providerId);
    }

    @Deprecated
    public List<String> getActingParameters() {
        return this.actingParameters;
    }

    public Feature<List<ActingParameterModel>> getParameters() {
        if (this.parameters == null) {
            this.parameters = Feature.disabled();
        }
        return this.parameters;
    }

    public Integer getPartOrder() {
        return this.partOrder;
    }

    public String getProviderName() {
        return this.providerName;
    }

    public boolean requiresConfiguration() {
        return this.requiresConfiguration;
    }

    public boolean requiresConnection() {
        return this.requiresConnection;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public Feature<String> getProviderId() {
        if (this.providerId == null) {
            this.providerId = Feature.disabled();
        }
        return this.providerId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValueProviderModel that = (ValueProviderModel)o;
        return new EqualsBuilder().append(this.parameters, that.parameters).append((Object)this.partOrder, (Object)that.partOrder).append((Object)this.providerName, (Object)that.providerName).append(this.requiresConnection, that.requiresConnection).append(this.requiresConfiguration, that.requiresConfiguration).append(this.isOpen, that.isOpen).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.parameters).append((Object)this.partOrder).append((Object)this.providerName).append(this.requiresConnection).append(this.requiresConfiguration).append(this.isOpen).toHashCode();
    }

    public String toString() {
        return "ValueProviderModel{providerName='" + this.providerName + '\'' + ", providerId=" + (this.providerId.isEnabled() ? this.providerId.get() : "DISABLED") + ", partOrder=" + this.partOrder + ", requiresConfiguration=" + this.requiresConfiguration + ", requiresConnection=" + this.requiresConnection + ", isOpen=" + this.isOpen + ", actingParameters=" + this.actingParameters + ", parameters=" + (this.parameters.isEnabled() ? this.parameters.get() : "DISABLED") + '}';
    }
}

