/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.bootstrap.internal.wrapper;

import static java.util.Objects.requireNonNull;
import static org.mule.tooling.client.internal.serialization.SerializationUtils.deserialize;
import static org.mule.tooling.client.internal.serialization.SerializationUtils.serialize;
import org.mule.tooling.client.api.connectivity.ConnectionValidationResult;
import org.mule.tooling.client.api.connectivity.ConnectivityTestingObjectNotFoundException;
import org.mule.tooling.client.api.connectivity.ConnectivityTestingRequest;
import org.mule.tooling.client.api.connectivity.ConnectivityTestingService;
import org.mule.tooling.client.api.connectivity.UnsupportedConnectivityTestingObjectException;
import org.mule.tooling.client.api.exception.NoSuchApplicationException;
import org.mule.tooling.client.api.exception.ServiceUnavailableException;
import org.mule.tooling.client.bootstrap.internal.reflection.Dispatcher;

import com.google.common.collect.ImmutableList;

/**
 * Client side implementation for {@link ConnectivityTestingService} that uses reflection and works as a bridge
 * between {@link ClassLoader classLoaders}.
 *
 * @since 1.0
 */
public class ConnectivityTestingServiceWrapper implements ConnectivityTestingService {

  private Dispatcher dispatcher;

  public ConnectivityTestingServiceWrapper(Dispatcher dispatcher) {
    requireNonNull(dispatcher, "dispatcher cannot be null");

    this.dispatcher = dispatcher;
  }

  @Override
  public ConnectionValidationResult testConnection(ConnectivityTestingRequest connectivityTestingRequest)
      throws NoSuchApplicationException, UnsupportedConnectivityTestingObjectException,
      ConnectivityTestingObjectNotFoundException, ServiceUnavailableException {
    String result = (String) dispatcher.dispatchRemoteMethod("testConnection",
                                                             connectivityTestingRequest.getRequestTimeout(),
                                                             ImmutableList.of(ConnectivityTestingRequest.class),
                                                             ImmutableList.of(serialize(connectivityTestingRequest)));
    return deserialize(result);
  }
}
