/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.bootstrap.internal.wrapper;

import static java.util.Objects.requireNonNull;
import static org.mule.tooling.client.internal.serialization.SerializationUtils.deserialize;
import org.mule.tooling.client.api.artifact.ToolingArtifact;
import org.mule.tooling.client.api.connectivity.ConnectivityTestingService;
import org.mule.tooling.client.api.datasense.DataSenseService;
import org.mule.tooling.client.api.dataweave.DataWeaveService;
import org.mule.tooling.client.api.metadata.MetadataService;
import org.mule.tooling.client.api.value.provider.ValueProviderService;
import org.mule.tooling.client.bootstrap.internal.reflection.Dispatcher;

import java.util.Map;

/**
 * Client side implementation for {@link ToolingArtifact} that uses reflection and works as a bridge
 * between {@link ClassLoader classLoaders}.
 *
 * @since 1.0
 */
public class ToolingArtifactWrapper implements ToolingArtifact {

  private Dispatcher dispatcher;

  public ToolingArtifactWrapper(Dispatcher dispatcher) {
    requireNonNull(dispatcher, "dispatcher cannot be null");

    this.dispatcher = dispatcher;
  }

  @Override
  public String getId() {
    return deserialize((String) dispatcher.dispatchRemoteMethod("id"));
  }

  @Override
  public Map<String, String> getProperties() {
    return deserialize((String) dispatcher.dispatchRemoteMethod("getProperties"));
  }

  @Override
  public ConnectivityTestingService connectivityTestingService() {
    Object connectivityTestingServiceTarget = dispatcher.dispatchRemoteMethod("connectivityTestingService");
    return new ConnectivityTestingServiceWrapper(dispatcher.newReflectionInvoker(connectivityTestingServiceTarget));
  }

  @Override
  public MetadataService metadataService() {
    Object metadataServiceTarget = dispatcher.dispatchRemoteMethod("metadataService");
    return new MetadataServiceWrapper(dispatcher.newReflectionInvoker(metadataServiceTarget));
  }

  @Override
  public DataSenseService dataSenseService() {
    Object dataSenseServiceTarget = dispatcher.dispatchRemoteMethod("dataSenseService");
    return new DataSenseServiceWrapper(dispatcher.newReflectionInvoker(dataSenseServiceTarget));
  }

  @Override
  public DataWeaveService dataWeaveService() {
    Object dataWeaveServiceTarget = dispatcher.dispatchRemoteMethod("dataWeaveService");
    return new DataWeaveServiceWrapper(dispatcher.newReflectionInvoker(dataWeaveServiceTarget));
  }

  @Override
  public ValueProviderService valueProviderService() {
    Object valueProviderServiceTarget = dispatcher.dispatchRemoteMethod("valueProviderService");
    return new ValueProviderServiceWrapper(dispatcher.newReflectionInvoker(valueProviderServiceTarget));
  }

  @Override
  public void dispose() {
    dispatcher.dispatchRemoteMethod("dispose");
  }

}
