/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.bootstrap.internal.wrapper;

import com.google.common.collect.ImmutableList;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.mule.tooling.client.api.ToolingRuntimeClient;
import org.mule.tooling.client.api.artifact.ToolingArtifact;
import org.mule.tooling.client.api.artifact.declaration.ArtifactSerializationService;
import org.mule.tooling.client.api.artifact.dsl.DslSyntaxResolverService;
import org.mule.tooling.client.api.exception.ToolingArtifactNotFoundException;
import org.mule.tooling.client.api.extension.ExtensionModelService;
import org.mule.tooling.client.api.message.history.MessageHistoryService;
import org.mule.tooling.client.bootstrap.internal.reflection.Dispatcher;
import org.mule.tooling.client.bootstrap.internal.wrapper.ArtifactSerializationServiceWrapper;
import org.mule.tooling.client.bootstrap.internal.wrapper.DslSyntaxResolverServiceWrapper;
import org.mule.tooling.client.bootstrap.internal.wrapper.ExtensionModelServiceWrapper;
import org.mule.tooling.client.bootstrap.internal.wrapper.MessageHistoryServiceWrapper;
import org.mule.tooling.client.bootstrap.internal.wrapper.ToolingArtifactWrapper;
import org.mule.tooling.client.internal.serialization.SerializationUtils;

public class ToolingRuntimeClientWrappper
implements ToolingRuntimeClient {
    private Dispatcher dispatcher;

    public ToolingRuntimeClientWrappper(Dispatcher dispatcher) {
        Objects.requireNonNull(dispatcher, "dispatcher cannot be null");
        this.dispatcher = dispatcher;
    }

    public ToolingArtifact newToolingArtifact(URL applicationUrlContent, Map<String, String> properties) {
        Object toolingArtifactTarget = this.dispatcher.dispatchRemoteMethod("newToolingArtifact", (List<Class>)ImmutableList.of(URL.class, Map.class), (List<String>)ImmutableList.of((Object)SerializationUtils.serialize((Object)applicationUrlContent), (Object)SerializationUtils.serialize(properties)));
        return new ToolingArtifactWrapper(this.dispatcher.newReflectionInvoker(toolingArtifactTarget));
    }

    public ToolingArtifact fetchToolingArtifact(String id) throws ToolingArtifactNotFoundException {
        Object toolingArtifactTarget = this.dispatcher.dispatchRemoteMethod("fetchToolingArtifact", (List<Class>)ImmutableList.of(String.class), (List<String>)ImmutableList.of((Object)SerializationUtils.serialize((Object)id)));
        return new ToolingArtifactWrapper(this.dispatcher.newReflectionInvoker(toolingArtifactTarget));
    }

    public ExtensionModelService extensionModelService() {
        Object extensionModelServiceTarget = this.dispatcher.dispatchRemoteMethod("extensionModelService");
        return new ExtensionModelServiceWrapper(this.dispatcher.newReflectionInvoker(extensionModelServiceTarget));
    }

    public ArtifactSerializationService artifactSerializationService() {
        Object artifactSerializationServiceTarget = this.dispatcher.dispatchRemoteMethod("artifactSerializationService");
        return new ArtifactSerializationServiceWrapper(this.dispatcher.newReflectionInvoker(artifactSerializationServiceTarget));
    }

    public DslSyntaxResolverService dslSyntaxResolverService() {
        Object dslSyntaxResolverServiceTarget = this.dispatcher.dispatchRemoteMethod("dslSyntaxResolverService");
        return new DslSyntaxResolverServiceWrapper(this.dispatcher.newReflectionInvoker(dslSyntaxResolverServiceTarget));
    }

    public MessageHistoryService messageHistoryService() {
        Object messageHistoryServiceTarget = this.dispatcher.dispatchRemoteMethod("messageHistoryService");
        return new MessageHistoryServiceWrapper(this.dispatcher.newReflectionInvoker(messageHistoryServiceTarget));
    }
}

