/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.bootstrap.internal;

import static java.util.Optional.ofNullable;
import static org.mule.tooling.client.internal.util.Preconditions.checkNotNull;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.tooling.client.bootstrap.api.ExecutorServiceConfiguration;
import org.mule.tooling.client.bootstrap.api.ToolingRuntimeClientBootstrapConfiguration;

import java.net.URI;
import java.util.Optional;

/**
 * Default implementation of {@link ToolingRuntimeClientBootstrapConfiguration.ToolingRuntimeClientBootstrapConfigurationBuilder}.
 */
public class DefaultToolingRuntimeClientBootstrapConfigurationBuilder implements
    ToolingRuntimeClientBootstrapConfiguration.ToolingRuntimeClientBootstrapConfigurationBuilder {

  private String muleVersion;
  private MavenConfiguration mavenConfiguration;
  private URI log4jConfiguration;
  private ExecutorServiceConfiguration executorServiceConfiguration;

  @Override
  public ToolingRuntimeClientBootstrapConfiguration.ToolingRuntimeClientBootstrapConfigurationBuilder muleVersion(
                                                                                                                  String muleVersion) {
    this.muleVersion = muleVersion;
    return this;
  }

  @Override
  public ToolingRuntimeClientBootstrapConfiguration.ToolingRuntimeClientBootstrapConfigurationBuilder mavenConfiguration(
                                                                                                                         MavenConfiguration mavenConfiguration) {
    this.mavenConfiguration = mavenConfiguration;
    return this;
  }

  @Override
  public ToolingRuntimeClientBootstrapConfiguration.ToolingRuntimeClientBootstrapConfigurationBuilder log4jConfiguration(
                                                                                                                         URI log4jConfiguration) {
    this.log4jConfiguration = log4jConfiguration;
    return this;
  }

  @Override
  public ToolingRuntimeClientBootstrapConfiguration.ToolingRuntimeClientBootstrapConfigurationBuilder executorServiceConfiguration(
                                                                                                                                   ExecutorServiceConfiguration executorServiceConfiguration) {
    this.executorServiceConfiguration = executorServiceConfiguration;
    return this;
  }

  @Override
  public ToolingRuntimeClientBootstrapConfiguration build() {
    return new DefaultToolingRuntimeClientBootstrapConfiguration(muleVersion, mavenConfiguration, log4jConfiguration,
                                                                 executorServiceConfiguration);
  }

  private static class DefaultToolingRuntimeClientBootstrapConfiguration implements ToolingRuntimeClientBootstrapConfiguration {

    private String muleVersion;
    private MavenConfiguration mavenConfiguration;
    private URI log4jConfiguration;
    private ExecutorServiceConfiguration executorServiceConfiguration;

    DefaultToolingRuntimeClientBootstrapConfiguration(String muleVersion, MavenConfiguration mavenConfiguration,
                                                      URI log4jConfiguration,
                                                      ExecutorServiceConfiguration executorServiceConfiguration) {
      checkNotNull(muleVersion, "muleVersion cannot be null");
      checkNotNull(mavenConfiguration, "mavenConfiguration cannot be null");

      this.muleVersion = muleVersion;
      this.mavenConfiguration = mavenConfiguration;
      this.log4jConfiguration = log4jConfiguration;
      this.executorServiceConfiguration = executorServiceConfiguration;
    }

    @Override
    public String muleVersion() {
      return muleVersion;
    }

    @Override
    public MavenConfiguration mavenConfiguration() {
      return mavenConfiguration;
    }

    @Override
    public Optional<URI> log4jConfiguration() {
      return ofNullable(log4jConfiguration);
    }

    @Override
    public Optional<ExecutorServiceConfiguration> executorServiceConfiguration() {
      return ofNullable(executorServiceConfiguration);
    }
  }
}
