/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.bootstrap.internal.wrapper;

import static java.util.Objects.requireNonNull;
import org.mule.tooling.client.api.datasense.DataSenseComponentInfo;
import org.mule.tooling.client.api.datasense.DataSenseInfo;
import org.mule.tooling.client.api.datasense.DataSenseRequest;
import org.mule.tooling.client.api.datasense.DataSenseService;
import org.mule.tooling.client.api.dataweave.DataWeaveService;
import org.mule.tooling.client.bootstrap.internal.reflection.Dispatcher;
import org.mule.tooling.client.internal.serialization.XStreamClientSerializer;

import com.google.common.collect.ImmutableList;

import java.util.Optional;

/**
 * Client side implementation for {@link DataWeaveService} that uses reflection and works as a bridge
 * between {@link ClassLoader classLoaders}.
 *
 * @since 1.0
 */
public class DataSenseServiceWrapper implements DataSenseService {

  private Dispatcher dispatcher;
  private XStreamClientSerializer serializer;

  public DataSenseServiceWrapper(Dispatcher dispatcher,
                                 XStreamClientSerializer serializer) {
    requireNonNull(dispatcher, "dispatcher cannot be null");
    requireNonNull(serializer, "serializer cannot be null");

    this.dispatcher = dispatcher;
    this.serializer = serializer;
  }

  @Override
  public Optional<DataSenseInfo> resolveDataSense(DataSenseRequest dataSenseRequest) {
    String result = (String) dispatcher.dispatchRemoteMethod("resolveDataSense",
                                                             dataSenseRequest.getRequestTimeout(),
                                                             ImmutableList.of(DataSenseRequest.class),
                                                             ImmutableList.of(serializer.serialize(dataSenseRequest)));
    return serializer.deserialize(result);
  }

  @Override
  public Optional<DataSenseComponentInfo> resolveComponentDataSense(DataSenseRequest dataSenseRequest) {
    String result = (String) dispatcher.dispatchRemoteMethod("resolveComponentDataSense",
                                                             dataSenseRequest.getRequestTimeout(),
                                                             ImmutableList.of(DataSenseRequest.class),
                                                             ImmutableList.of(serializer.serialize(dataSenseRequest)));
    return serializer.deserialize(result);
  }

}
