/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.bootstrap.internal.wrapper;

import static java.util.Objects.requireNonNull;
import org.mule.tooling.client.api.value.ValueResult;
import org.mule.tooling.client.api.value.provider.ValueProviderRequest;
import org.mule.tooling.client.api.value.provider.ValueProviderService;
import org.mule.tooling.client.bootstrap.internal.reflection.Dispatcher;
import org.mule.tooling.client.internal.serialization.XStreamClientSerializer;

import com.google.common.collect.ImmutableList;

/**
 * Client side implementation for {@link ValueProviderService} that uses reflection and works as a bridge
 * between {@link ClassLoader classLoaders}.
 *
 * @since 1.0
 */
public class ValueProviderServiceWrapper implements ValueProviderService {

  private Dispatcher dispatcher;
  private XStreamClientSerializer serializer;

  public ValueProviderServiceWrapper(Dispatcher dispatcher,
                                     XStreamClientSerializer serializer) {
    requireNonNull(dispatcher, "dispatcher cannot be null");
    requireNonNull(serializer, "serializer cannot be null");

    this.dispatcher = dispatcher;
    this.serializer = serializer;
  }

  @Override
  public ValueResult getValues(ValueProviderRequest valueProviderRequest) {
    String result = (String) dispatcher.dispatchRemoteMethod("getValues",
                                                             valueProviderRequest.getRequestTimeout(),
                                                             ImmutableList.of(ValueProviderRequest.class),
                                                             ImmutableList.of(serializer.serialize(valueProviderRequest)));
    return serializer.deserialize(result);
  }

}
