/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.bootstrap.api;

import org.mule.tooling.client.bootstrap.internal.DefaultToolingRuntimeClientBootstrapConfigurationBuilder;

/**
 * Configuration for {@link ToolingRuntimeClientBootstrap} executor service.
 *
 * @since 1.0
 */
public interface ExecutorServiceConfiguration {

  /**
   * @return maximum number of thread to be used by {@link ToolingRuntimeClientBootstrap}.
   */
  int maxNumberOfThreads();

  static ToolingRuntimeClientBootstrapConfiguration.ToolingRuntimeClientBootstrapConfigurationBuilder builder() {
    return new DefaultToolingRuntimeClientBootstrapConfigurationBuilder();
  }

  /**
   * Builder for {@link ExecutorServiceConfiguration}.
   *
   * @since 1.0
   */
  interface ExecutorServiceConfigurationBuilder {

    /**
     * @param maxNumberOfThreads the max number of threads to be used by {@link ToolingRuntimeClientBootstrap}. Be aware that
     *                           this will be shared amount the {@link org.mule.tooling.client.api.ToolingRuntimeClient ToolingRuntimeClients}
     *                           created by this {@link ToolingRuntimeClientBootstrap}.
     */
    ExecutorServiceConfigurationBuilder maxNumberOfThreads(int maxNumberOfThreads);

    /**
     * @return builds the {@link ToolingRuntimeClientBootstrapConfiguration}.
     */
    ToolingRuntimeClientBootstrapConfiguration build();

  }

}
