/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.bootstrap.internal.wrapper;

import static java.util.Objects.requireNonNull;
import org.mule.tooling.client.api.descriptors.ArtifactDescriptor;
import org.mule.tooling.client.api.icons.ExtensionIconsService;
import org.mule.tooling.client.api.icons.IconsResult;
import org.mule.tooling.client.bootstrap.internal.reflection.Dispatcher;
import org.mule.tooling.client.internal.serialization.XStreamClientSerializer;

import com.google.common.collect.ImmutableList;

/**
 * Client side implementation for {@link ExtensionIconsService} that uses reflection and works as a bridge
 * between {@link ClassLoader classLoaders}.
 *
 * @since 1.1
 */
public class IconsServiceWrapper implements ExtensionIconsService {

  private Dispatcher dispatcher;
  private XStreamClientSerializer serializer;

  IconsServiceWrapper(Dispatcher dispatcher, XStreamClientSerializer serializer) {
    requireNonNull(dispatcher, "dispatcher cannot be null");
    requireNonNull(serializer, "serializer cannot be null");

    this.dispatcher = dispatcher;
    this.serializer = serializer;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public IconsResult getIconsFor(ArtifactDescriptor artifactDescriptor) {
    String result = (String) dispatcher.dispatchRemoteMethod("getIconsFor",
                                                             -1,
                                                             ImmutableList.of(ArtifactDescriptor.class),
                                                             ImmutableList.of(serializer.serialize(artifactDescriptor)));
    return (IconsResult) serializer.deserialize(result);
  }
}
