/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.bootstrap.internal;

import static java.lang.System.clearProperty;
import static java.lang.System.setProperty;
import static org.hamcrest.core.Is.is;
import static org.junit.Assert.assertThat;
import static org.mule.tooling.client.bootstrap.internal.VersionResolver.mapToolingVersion;
import static org.mule.tooling.client.bootstrap.internal.VersionResolver.TOOLING_VERSION_PROPERTY;
import static org.mule.tooling.client.bootstrap.internal.VersionResolver.TOOLING_VERSION_PROPERTY_MAPPING_SEPARATOR;
import static org.mule.tooling.client.bootstrap.internal.VersionResolver.TOOLING_VERSION_PROPERTY_SEPARATOR;

import org.junit.After;
import org.junit.Test;

import java.io.IOException;

public class VersionResolverTestCase {

  private static final String TEST_VERSION = "test-version";
  private static final String TEST_TOOLING_MAPPED_VERSION = "test-tooling-version";
  private static final String TEST_VERSION_IN_FILE = "version1";
  private static final String TEST_TOOLING_MAPPED_IN_FILE = "tooling1";

  @After
  public void tearDown() {
    clearProperty(TOOLING_VERSION_PROPERTY);
  }

  @Test
  public void mapWithoutConfiguration() {
    assertThat(mapToolingVersion(this.getClass().getClassLoader(), TEST_VERSION), is(TEST_VERSION));
  }

  @Test
  public void mapWithSystemProperty() {
    setProperty(TOOLING_VERSION_PROPERTY,
                TEST_VERSION + TOOLING_VERSION_PROPERTY_MAPPING_SEPARATOR + TEST_TOOLING_MAPPED_VERSION
                    + TOOLING_VERSION_PROPERTY_SEPARATOR + "otherVersion" + TOOLING_VERSION_PROPERTY_MAPPING_SEPARATOR
                    + "otherToolingVersion");

    assertThat(mapToolingVersion(this.getClass().getClassLoader(), TEST_VERSION), is(TEST_TOOLING_MAPPED_VERSION));
  }

  @Test
  public void mapWithPropertyFile() throws IOException {
    assertThat(mapToolingVersion(this.getClass().getClassLoader(), TEST_VERSION_IN_FILE), is(TEST_TOOLING_MAPPED_IN_FILE));
  }

  @Test
  public void mapWithSystemPropertyAndPropertyFile() {
    setProperty(TOOLING_VERSION_PROPERTY,
                TEST_VERSION_IN_FILE + TOOLING_VERSION_PROPERTY_MAPPING_SEPARATOR + TEST_TOOLING_MAPPED_VERSION);
    assertThat(mapToolingVersion(this.getClass().getClassLoader(), TEST_VERSION_IN_FILE), is(TEST_TOOLING_MAPPED_VERSION));
  }

}
