/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.bootstrap.internal.wrapper;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.mule.tooling.client.api.descriptors.ArtifactDescriptor;
import org.mule.tooling.client.api.extension.ExtensionModelService;
import org.mule.tooling.client.api.extension.model.ExtensionModel;
import org.mule.tooling.client.bootstrap.internal.reflection.Dispatcher;
import org.mule.tooling.client.internal.serialization.XStreamClientSerializer;

public class ExtensionModelServiceWrapper
implements ExtensionModelService {
    private Dispatcher dispatcher;
    private XStreamClientSerializer serializer;

    public ExtensionModelServiceWrapper(Dispatcher dispatcher, XStreamClientSerializer serializer) {
        Objects.requireNonNull(dispatcher, "dispatcher cannot be null");
        Objects.requireNonNull(serializer, "serializer cannot be null");
        this.dispatcher = dispatcher;
        this.serializer = serializer;
    }

    public Optional<ExtensionModel> loadExtensionModel(ArtifactDescriptor pluginDescriptor) {
        String result = (String)this.dispatcher.dispatchRemoteMethod("loadExtensionModel", (List<Class>)ImmutableList.of(ArtifactDescriptor.class), (List<String>)ImmutableList.of((Object)this.serializer.serialize((Object)pluginDescriptor)));
        return (Optional)this.serializer.deserialize(result);
    }

    public Optional<ExtensionModel> loadExtensionModel(File plugin) {
        String result = (String)this.dispatcher.dispatchRemoteMethod("loadExtensionModel", (List<Class>)ImmutableList.of(File.class), (List<String>)ImmutableList.of((Object)this.serializer.serialize((Object)plugin)));
        return (Optional)this.serializer.deserialize(result);
    }

    public Optional<String> loadExtensionSchema(ArtifactDescriptor pluginDescriptor) {
        String result = (String)this.dispatcher.dispatchRemoteMethod("loadExtensionSchema", (List<Class>)ImmutableList.of(ArtifactDescriptor.class), (List<String>)ImmutableList.of((Object)this.serializer.serialize((Object)pluginDescriptor)));
        return (Optional)this.serializer.deserialize(result);
    }

    public Optional<String> loadExtensionSchema(File plugin) {
        String result = (String)this.dispatcher.dispatchRemoteMethod("loadExtensionSchema", (List<Class>)ImmutableList.of(File.class), (List<String>)ImmutableList.of((Object)this.serializer.serialize((Object)plugin)));
        return (Optional)this.serializer.deserialize(result);
    }

    public List<ExtensionModel> loadMuleExtensionModels() {
        String result = (String)this.dispatcher.dispatchRemoteMethod("loadMuleExtensionModels");
        return (List)this.serializer.deserialize(result);
    }
}

