/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.bootstrap.internal.wrapper;

import com.google.common.collect.ImmutableList;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.mule.tooling.client.api.ToolingRuntimeClient;
import org.mule.tooling.client.api.artifact.ToolingArtifact;
import org.mule.tooling.client.api.artifact.declaration.ArtifactSerializationService;
import org.mule.tooling.client.api.artifact.dsl.DslSyntaxResolverService;
import org.mule.tooling.client.api.exception.ToolingArtifactNotFoundException;
import org.mule.tooling.client.api.extension.ExtensionModelService;
import org.mule.tooling.client.api.icons.ExtensionIconsService;
import org.mule.tooling.client.api.message.history.MessageHistoryService;
import org.mule.tooling.client.bootstrap.internal.reflection.Dispatcher;
import org.mule.tooling.client.bootstrap.internal.wrapper.ArtifactSerializationServiceWrapper;
import org.mule.tooling.client.bootstrap.internal.wrapper.DslSyntaxResolverServiceWrapper;
import org.mule.tooling.client.bootstrap.internal.wrapper.ExtensionModelServiceWrapper;
import org.mule.tooling.client.bootstrap.internal.wrapper.IconsServiceWrapper;
import org.mule.tooling.client.bootstrap.internal.wrapper.MessageHistoryServiceWrapper;
import org.mule.tooling.client.bootstrap.internal.wrapper.ToolingArtifactWrapper;
import org.mule.tooling.client.internal.serialization.XStreamClientSerializer;

public class ToolingRuntimeClientWrappper
implements ToolingRuntimeClient {
    private Dispatcher dispatcher;
    private XStreamClientSerializer serializer;

    public ToolingRuntimeClientWrappper(Dispatcher dispatcher, XStreamClientSerializer serializer) {
        Objects.requireNonNull(dispatcher, "dispatcher cannot be null");
        Objects.requireNonNull(serializer, "serializer cannot be null");
        this.dispatcher = dispatcher;
        this.serializer = serializer;
    }

    public ToolingArtifact newToolingArtifact(URL applicationUrlContent, Map<String, String> properties) {
        Object toolingArtifactTarget = this.dispatcher.dispatchRemoteMethod("newToolingArtifact", (List<Class>)ImmutableList.of(URL.class, Map.class), (List<String>)ImmutableList.of((Object)this.serializer.serialize((Object)applicationUrlContent), (Object)this.serializer.serialize(properties)));
        return new ToolingArtifactWrapper(this.dispatcher.newReflectionInvoker(toolingArtifactTarget), this.serializer);
    }

    public ToolingArtifact fetchToolingArtifact(String id) throws ToolingArtifactNotFoundException {
        Object toolingArtifactTarget = this.dispatcher.dispatchRemoteMethod("fetchToolingArtifact", (List<Class>)ImmutableList.of(String.class), (List<String>)ImmutableList.of((Object)this.serializer.serialize((Object)id)));
        return new ToolingArtifactWrapper(this.dispatcher.newReflectionInvoker(toolingArtifactTarget), this.serializer);
    }

    public ExtensionModelService extensionModelService() {
        Object extensionModelServiceTarget = this.dispatcher.dispatchRemoteMethod("extensionModelService");
        return new ExtensionModelServiceWrapper(this.dispatcher.newReflectionInvoker(extensionModelServiceTarget), this.serializer);
    }

    public ArtifactSerializationService artifactSerializationService() {
        Object artifactSerializationServiceTarget = this.dispatcher.dispatchRemoteMethod("artifactSerializationService");
        return new ArtifactSerializationServiceWrapper(this.dispatcher.newReflectionInvoker(artifactSerializationServiceTarget), this.serializer);
    }

    public DslSyntaxResolverService dslSyntaxResolverService() {
        Object dslSyntaxResolverServiceTarget = this.dispatcher.dispatchRemoteMethod("dslSyntaxResolverService");
        return new DslSyntaxResolverServiceWrapper(this.dispatcher.newReflectionInvoker(dslSyntaxResolverServiceTarget), this.serializer);
    }

    public MessageHistoryService messageHistoryService() {
        Object messageHistoryServiceTarget = this.dispatcher.dispatchRemoteMethod("messageHistoryService");
        return new MessageHistoryServiceWrapper(this.dispatcher.newReflectionInvoker(messageHistoryServiceTarget), this.serializer);
    }

    public ExtensionIconsService iconsService() {
        Object iconsServiceTarget = this.dispatcher.dispatchRemoteMethod("iconsService");
        return new IconsServiceWrapper(this.dispatcher.newReflectionInvoker(iconsServiceTarget), this.serializer);
    }
}

